/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemDice
extends ItemRelic {
    public static final Supplier<List<ItemStack>> RELIC_STACKS = Suppliers.memoize(() -> List.of(new ItemStack((ItemLike)ModItems.infiniteFruit), new ItemStack((ItemLike)ModItems.kingKey), new ItemStack((ItemLike)ModItems.flugelEye), new ItemStack((ItemLike)ModItems.thorRing), new ItemStack((ItemLike)ModItems.odinRing), new ItemStack((ItemLike)ModItems.lokiRing)));

    public ItemDice(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IRelic relic = IXplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.isRightPlayer(player)) {
            if (world.f_46443_) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.diceOfFate, SoundSource.PLAYERS, 1.0f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
            ArrayList<Integer> possible = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                if (this.hasRelicAlready(player, i)) continue;
                possible.add(i);
            }
            if (!possible.isEmpty()) {
                int relicIdx = (Integer)possible.get(world.f_46441_.nextInt(possible.size()));
                player.m_6352_((Component)new TranslatableComponent("botaniamisc.diceRoll", new Object[]{relicIdx + 1}).m_130940_(ChatFormatting.DARK_GREEN), Util.f_137441_);
                ItemStack toGive = RELIC_STACKS.get().get(relicIdx).m_41777_();
                return InteractionResultHolder.m_19090_((Object)toGive);
            }
            int roll = world.f_46441_.nextInt(6) + 1;
            ResourceLocation tableId = ResourceLocationHelper.prefix("dice/roll_" + roll);
            LootTable table = world.m_142572_().m_129898_().m_79217_(tableId);
            LootContext context = new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78963_(player.m_36336_()).m_78975_(LootContextParamSets.f_81416_);
            List generated = table.m_79129_(context);
            for (ItemStack drop : generated) {
                if (player.m_150109_().m_36054_(drop)) continue;
                player.m_36176_(drop, false);
            }
            String langKey = generated.isEmpty() ? "botaniamisc.dudDiceRoll" : "botaniamisc.diceRoll";
            player.m_6352_((Component)new TranslatableComponent(langKey, new Object[]{roll}).m_130940_(ChatFormatting.DARK_GREEN), Util.f_137441_);
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)new TextComponent(""));
        TooltipHandler.addOnShift(tooltip, () -> {
            String name = stack.m_41778_() + ".poem";
            for (int i = 0; i < 4; ++i) {
                tooltip.add((Component)new TranslatableComponent(name + i).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        });
    }

    public static IRelic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null){

            @Override
            public boolean shouldDamageWrongPlayer() {
                return false;
            }
        };
    }

    private boolean hasRelicAlready(Player player, int relicId) {
        if (relicId < 0 || relicId > 6 || !(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer mpPlayer = (ServerPlayer)player;
        ItemStack stack = RELIC_STACKS.get().get(relicId);
        IRelic relic = IXplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && relic.getAdvancement() != null) {
            return PlayerHelper.hasAdvancement(mpPlayer, relic.getAdvancement());
        }
        return false;
    }
}

